//+------------------------------------------------------------------+
//|                                                wxLunarCycles.mq4 |
//|                      Copyright  2005, MetaQuotes Software Corp. |
//|                                        http://www.metaquotes.net |
//+------------------------------------------------------------------+
#property copyright "Copyright  2005, MetaQuotes Software Corp."
#property link      "http://www.metaquotes.net"


//+------------------------------------------------------------------+
//| script program start function                                    |
//+------------------------------------------------------------------+
int start()
  {
//----
   
	
	string EDate, Description;
	int TimeIndex;
	color Colour;
	double Buffer;
	
	int handle;
	handle=FileOpen("yearlyseasoncycle.csv",FILE_CSV|FILE_READ,',');
	if(handle<1)
 	{
  		Print("File my_data.dat not found, the last error is ", GetLastError());
  		return(false);
 	}

   if(Symbol() == "EURUSD" || Symbol() == "GBPUSD")
      Buffer = 100*Point;
   if(Symbol() == "AUDUSD")
      Buffer = 100*Point;
   if(Symbol() == "GOLD")
      Buffer = 1000*Point;      
   if(Symbol() == "_CL")
      Buffer = 10*Point;
   if(Symbol() == "_SP500")
      Buffer = 2000*Point;
   if(Symbol() == "_DJI")
      Buffer = 2000*Point;


	while(!FileIsEnding(handle))
	{
		EDate = FileReadString(handle);
		Description = FileReadString(handle);
		//Alert(EDate, "--", Description);
		if(EDate == "") continue;
		datetime DDate = StrToTime(EDate);
		
		
		if(Description == "New") 
			Colour = Gray;
		else
			Colour = Magenta;
				
		SetObj(EDate + Description + MathRand(), OBJ_VLINE, StrToTime(EDate), 0, 1, Colour);
		
      TimeIndex=0;
      for(int j=0; j<Bars; j++)
      {
         if(Time[j]>=DDate && Time[j+1]<=DDate ) TimeIndex=j;
         if(TimeIndex != 0) break;
      }
		
		
		SetTxtObj(EDate + Description + "txt" + MathRand(), OBJ_TEXT, StrToTime(EDate), Low[TimeIndex]-Buffer, Description, 90, Colour);
	}
	
	FileClose(handle);
   
//----
   return(0);
  }
//+------------------------------------------------------------------+


int SetTxtObj(string Name, int ObjType, datetime Time1, double Price1, string ObjText, double Angle, color LColor) 
{
   if(ObjectFind(Name)<0)
   {
   //object not found create new one
      if(ObjType==OBJ_TEXT)
      {
         ObjectCreate(Name, OBJ_TEXT, 0, Time1, Price1);
         ObjectSetText(Name, ObjText, 10, "Times New Roman", LColor);
         ObjectSet(Name, OBJPROP_ANGLE, Angle);
         //ObjectSet(Name, OBJPROP_COLOR, LColor);         

      }   
   
   }
   else
   {
      if(ObjectType(Name)==OBJ_TEXT)
      {
         ObjectSet(Name, OBJPROP_TIME1, Time1);
         ObjectSet(Name, OBJPROP_PRICE1, Price1);
         ObjectSetText(Name, ObjText, 10, "Times New Roman", LColor);
         ObjectSet(Name, OBJPROP_ANGLE, Angle);
         //ObjectSet(Name, OBJPROP_COLOR, LColor);         

      }
   }
   return(0);
}

int SetObj(string Name, int ObjType, datetime Time1, double Price1, int Thickness, color LColor) 
{
   if(ObjectFind(Name)<0)
   {
   //object not found create new one
      if(ObjType==OBJ_VLINE)
      {
         ObjectCreate(Name, OBJ_VLINE, 0, Time1, Price1);
         ObjectSet(Name, OBJPROP_WIDTH, Thickness);
         ObjectSet(Name, OBJPROP_COLOR, LColor);         
         ObjectSet(Name, OBJPROP_STYLE, STYLE_DOT);
         
         
      
      	ObjectCreate(Name+"buffer", OBJ_RECTANGLE, 0, Time1-24*60*60, 0, Time1+24*60*60, 9999);
      	ObjectSet(Name+"buffer",OBJPROP_COLOR, Black);
           
      }   
   
   }
   else
   {
      if(ObjectType(Name)==OBJ_VLINE)
      {
         ObjectSet(Name, OBJPROP_TIME1, Time1);
         ObjectSet(Name, OBJPROP_PRICE1, Price1);
         
         ObjectSet(Name, OBJPROP_WIDTH, Thickness);
         ObjectSet(Name, OBJPROP_COLOR, LColor);         

      }
   }
   return(0);
}